@extends('admin.base')

@section('section_title')
{{ __('View Gallery') }}
<br />

<a href="/admin/galleries" class="text-indigo-700 hover:underline font-semibold">&raquo; {{ __('Back To Galleries') }}</a>
@endsection

@section('section_body')

<div class="max-w-lg bg-white rounded-lg shadow-sm p-3 text-stone-600">
    <form method="POST" action="/admin/galleries/save/{{ $gallery->id }}" enctype="multipart/form-data">
        @csrf
        <x-label>{{ __("Gallery Name") }}</x-label>

        <x-input id="title" class="block mt-0 w-full" type="text" value="{{ $gallery->gallery_name }}" name="title" required />

        <x-label class="mt-5">{{ __("Free for subscribers?") }}</x-label>

        <x-select name="free_for_subs" class="w-full">
            <option value="yes" @if($gallery->free_for_subs == "yes") selected @endif>{{ __("Yes") }}</option>
            <option value="no" @if($gallery->free_for_subs == "no") selected @endif>{{ __("No") }}</option>
        </x-select>

        <x-label class="mt-5">{{ __("Price") }}</x-label>

        <x-input id="price" class="block mt-0 w-full" type="text" value="{{ $gallery->price }}" name="price" required />

        <hr />
        <x-button class="mt-5">{{ __('Save') }}</x-button>
    </form>
</div>

<div class="max-w-4xl mt-5">
    <h3 class="text-indigo-700 text-lg font-bold">{{__('Photos in this gallery')}}</h3>
    @if(count($gallery->photos))
    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-4">
        @foreach($gallery->photos as $p)
        <div class="border-2 rounded-lg text-center">
            <img src="{{ \Storage::disk($p->disk)->url($p->photo)}}" class="w-full rounded-lg" />
            <a class="block" href="/admin/galleries/view/{{$gallery->id}}?remove_photo={{ $p->id }}" onclick="return confirm('{{ __('Are you sure you want to remove this PHOTO?')  }}')"><i class="fa-solid fa-trash text-red-400"></i></a>
        </div>
        @endforeach
    </div>
    @else
    <div class="my-5 bg-gray-200 text-gray-500 font-semibold border-2 border-gray-300 p-3 rounded">
        {{ __('No photos in this gallery.') }}
    </div>
    @endif
</div>



@endsection
